<?php

/**
 * Class Dashboard
 * This is a demo controller that simply shows an area that is only visible for the logged in user
 * because of Auth::handleLogin(); in line 19.
 */
class Leave extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    function __construct()
    {
        parent::__construct();
        // this controller should only be visible/usable by logged in users, so we put login-check here
		Auth::handleLogin();
    }

    /**
     * This method controls what happens when you move to /dashboard/index in your app.
     */
    function index(){
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		if($sts==1 || $hrsts==1){
			$this->view->render('leave/index');
		}else{
			$this->view->render('leave/index1');
		}        
    }
	
	function leave_reports(){
        $this->view->render('leave/reports_list');
    }
	
	
	/** 
	 									
	 /////////////////////////////  ////////////////////////////
	
	 /////////////////////////////    LEAVE TYPE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on leavetype table
     * getall function fetching leavetype list
	 * @returning json array of data as result
     */
	
	function leavetype()
    {
        
		$viewper = $this->CheckPermission(31, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(31, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('leave/leavetype/index');
		}else{
			header('location: ' . URL . 'leave/index');
		}
    }
	function addleavetype()
    {
		
		$addper = $this->CheckPermission(31, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->leavetypeid =0;
			$this->view->render('leave/leavetype/addeditleavetype');
		}else{
			header('location: ' . URL . 'leave/leavetype');
		}
    }
	
	function editleavetype($id)
    {
		$editper = $this->CheckPermission(31, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->leavetypeid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('leave/leavetype/addeditleavetype');
		}else{
			header('location: ' . URL . 'leave/leavetype');
		}
    }
	
	function getallleavetype()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$leavetype = $this->loadModel('Leavetype');
			$leavetypearray = $leavetype->getAll($arr);
			echo json_encode($leavetypearray);	
			
		
	}
	
	function getemployeeleave()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = date('d/m/Y');
			$leavetype = $this->loadModel('Leavetype');
			$leavetypearray = $leavetype->getEmployeeAllLeaveType($arr);
			echo json_encode($leavetypearray);	
			
		
	}
	
	function getselectedemployeeleave()
	{
		try{
			$arr = array();
			$arr[0] = $_POST['employeeid'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['applydate'];
			if($_POST['applydate']!="")
			{
				$leavetype = $this->loadModel('Leavetype');
				$leavetypearray = $leavetype->getEmployeeAllLeaveType($arr);
				echo json_encode($leavetypearray);	
			}
		}catch(Exception $e) {
			echo  'Message: ' .$e->getMessage();
		}	
		
	}
	
	function getallleaveemployee()
	{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$leavetype = $this->loadModel('Employee');
			$leavetypearray = $leavetype->getAllHierarchyEmployee($arr);
			echo json_encode($leavetypearray);	
			}catch(Exception $e){
				
			}
			
		
	}
	
	function getallleaveapprover()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['leaveid'];
			$leavetype = $this->loadModel('Leaveapproval');
			$leavetypearray = $leavetype->getAllApprover($arr);
			echo json_encode($leavetypearray);	
	}
	
function getalltimeoffapprover()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['timeoffid'];
			
			$leavetype = $this->loadModel('Leaveapproval');
			$leavetypearray = $leavetype->getAllTimeoffApprover($arr);
			echo json_encode($leavetypearray);	
			
		
	}	
	
	function getaleavetype()
	{
		$viewper = $this->CheckPermission(31, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['leavetypeid'];
			$leavetype = $this->loadModel('Leavetype');
			$leavetypearray = $leavetype->getDetail($gid);
			echo json_encode($leavetypearray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	/** 
     * Functions for perfom operation on leavetype table
     * getall function fetching leavetype list
	 * @returning json array of data as result
     */ 

	function createleavetype()
	{
		$addper = $this->CheckPermission(31, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['leavetypename'];
			$arr[3] = $_POST['leavedays'];
			$arr[4] = $_POST['fiscalid'];
			$arr[5] = $_POST['leaveusablests'];
			$arr[6] = $_POST['leaveallowedsts'];
			$arr[7] = $_POST['leavecolor'];
			$arr[8] = $_POST['departmentids'];
			$arr[9] = $_POST['designationids'];
			$arr[10] = $_POST['genderid'];
			$arr[11] = $_POST['maritalid'];
			$arr[12] = $_POST['employeeids'];
			$arr[13] = $_POST['employeeexperience']; 
			$arr[14] = $_POST['leavepayrule'];
			$arr[15] = $_POST['leaverule'];
			$arr[16] = $_POST['division'];
			$arr[17] = $_POST['grade'];
			$arr[18] = $_POST['leaveapply'];
			$arr[19] = $_POST['workday'];
			$arr[20] = $_POST['annualleave'];
			$arr[21] = $_POST['desc'];
			$arr[22] = $_POST['religion'];
			$arr[23] = $_POST['carryforward'];
			$arr[24] = $_POST['visiblests'];
			$arr[25] = $_POST['leavecal'];
			$arr[26] = $_POST['ProbationSts'];

			$dept = $this->loadModel('Leavetype');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on leavetype table
     * delete function from leavetype list
	 * @returning json array of data as result
     */
	 
	 function updatedeleavetype()
	{
				
		
		$editper = $this->CheckPermission(31, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['leavetypename'];
			$arr[3] = $_POST['leavedays'];
			$arr[4] = $_POST['fiscalid'];
			$arr[5] = $_POST['leaveusablests'];
			$arr[6] = $_POST['leaveallowedsts'];
			$arr[7] = $_POST['leavecolor'];
			$arr[8] = $_POST['departmentids'];
			$arr[9] = $_POST['designationids'];
			$arr[10] = $_POST['genderid'];
			$arr[11] = $_POST['maritalid'];
			$arr[12] = $_POST['employeeids'];
			$arr[13] = $_POST['employeeexperience']; 
			$arr[14] = $_POST['leavepayrule'];
			$arr[15] = $_POST['leaverule'];
			$arr[16] = $_POST['division'];
			$arr[17] = $_POST['grade'];
			$arr[18] = $_POST['leavetypeid'];
			$arr[19] = $_POST['leaveapply'];
			$arr[20] = $_POST['workday'];
			$arr[21] = $_POST['annualleave'];
			$arr[22] = $_POST['desc'];
			$arr[23] = $_POST['religion'];
			$arr[24] = $_POST['carryforward'];
			$arr[25] = $_POST['visiblests'];
			$arr[26] = $_POST['leavecal'];
			$arr[27] = $_POST['ProbationSts'];
			$dept = $this->loadModel('Leavetype');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteleavetype($did)
	{
		$deleteper = $this->CheckPermission(31, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Leavetype');
			$deptarray = $dept->Delete($did);
			echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getleavetypeData()
	{
		$editper = $this->CheckPermission(31, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(31, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$leavetype = $this->loadModel('Leavetype');
		$leavetypearray = $leavetype->getDataTable($editper, $deleteper);
		echo json_encode($leavetypearray);
	}

/** 
	 									
	 /////////////////////////////  ////////////////////////////
	
	 /////////////////////////////     EMPLOYEE LEAVE CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     * Functions for perfom operation on leavetype table
     * getall function fetching Employee Leave list
	 * @returning json array of data as result
     */
	
	function leaveslist()
    {
       
	   $viewper = $this->CheckPermission(18, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(18, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('leave/employeeleave/index');
		}else{
			header('location: ' . URL . 'leave/index');
		}
    }
	
	function leavebalancefiscal()
    {
       
	   $viewper = $this->CheckPermission(160, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(160, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('leave/leavebalance/index');
		}else{
			header('location: ' . URL . 'leave/index');
		}
    }
	function leavebalanceanniversary()
    {
       
	   $viewper = $this->CheckPermission(160, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(160, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('leave/leavebalance/anniversary');
		}else{
			header('location: ' . URL . 'leave/index');
		}
    }
	function lapsencashleave($id)
    {
       $this->view->leavehistoryid =Utils::decode5t($id);
	   $this->view->render('leave/leavebalance/editleavehistory');
		
    }
	
	function getleavebalancehistory()
	{
		$gid = $_POST['leavehistoryid'];
		$employeeleave = $this->loadModel('Leavetype');
		$employeeleavearray = $employeeleave->getLeavehistory($gid);
		echo json_encode($employeeleavearray);	
			
			
	}
	function updateleavehistory()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['leavehistoryid'];
			$arr[3] = $_POST['availleave'];
			$arr[4] = $_POST['encashlapseleave'];
			$arr[5] = $_POST['resettype']; 
			
			
			$dept = $this->loadModel('Leavetype');
			$deptarray = $dept->UpdateLeaveHistory($arr);
			echo json_encode($deptarray);		
		
	}
	
	function getLeaveBalanceData()
    {
       
	   $editper = $this->CheckPermission(160, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(160, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$leavetype = $this->loadModel('Leavetype');
		$leavetypearray = $leavetype->getLeaveBalanceDataTable($editper, $deleteper);
		echo json_encode($leavetypearray);
    }
	function getLeaveBalanceDataAnniversary()
    {
       
	   $editper = $this->CheckPermission(160, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(160, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$leavetype = $this->loadModel('Leavetype');
		$leavetypearray = $leavetype->getAnniversaryLeaveBalanceDataTable($editper, $deleteper);
		echo json_encode($leavetypearray);
    }

	function addemployeeleave()
    {
		
		$addper = $this->CheckPermission(18, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->employeeleaveid =0;
			$this->view->val = 0;
			$this->view->render('leave/employeeleave/addeditemployeeleave');
		}else{
			header('location: ' . URL . 'leave/leaveslist');
		}
    }
	
	function editemployeeleave($id)
    {		
		$editper = $this->CheckPermission(18, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->employeeleaveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('leave/employeeleave/addeditemployeeleave');
		}else{
			header('location: ' . URL . 'leave/leaveslist');
		}
    }
	
	function viewemployeeleave($id,$val)
    {
		$viewper = $this->CheckPermission(18, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if(isset($id) && ($viewper)  && isset($val))
		{
			$this->view->val = $val; 
			$this->view->employeeleaveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('leave/employeeleave/addeditleaveapproval');
		}else{
			header('location: ' . URL . 'leave/leaveslist');
		}
		
    }
	
	
	function getallemployeeleave()
	{		
		$viewper = $this->CheckPermission(18, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$employeeleave = $this->loadModel('Employeeleave');
			$employeeleavearray = $employeeleave->getAll($arr);
			echo json_encode($employeeleavearray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getaemployeeleave()
	{
		

		$viewper = $this->CheckPermission(18, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['employeeleaveid'];
			$employeeleave = $this->loadModel('Employeeleave');
			$employeeleavearray = $employeeleave->getDetail($gid);
			echo json_encode($employeeleavearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}

     function getLeaveDaysDiff()
	{
		try{
		$id =$_POST['employeeid'];
		$employeeleave = $this->loadModel('Profile');
		$employeeleavearray = $employeeleave->getLeaveDaysDifference($id );
		echo json_encode($employeeleavearray);
		}catch(Exception $e){}
	}
	
	/** 
     * Functions for perfom operation on leavetype table
     * getall function fetching leavetype list
	 * @returning json array of data as result
	 * @returning json array of data as result
	 * @returning json array of data as result
     */ 

	function createemployeeleave()
	{
		$addper = $this->CheckPermission(18, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['leavefrom'];
			$arr[4] = $_POST['leaveto'];
			$arr[5] = $_POST['leavereason'];
			$arr[6] = $_POST['leavetypeid']; 
			$arr[7] = $_POST['resumptiondate'];
			$arr[8] = $_POST['applydate']; 
			$arr[9] = $_POST['leavestatus']; 
			$arr[10] = $_POST['approvedby']; 
			$arr[11] = $_POST['approvercomment'];
			$arr[12] = $_POST['contactdetail'];		
			$arr[13] = $_POST['dayseligible'];				
			$arr[14] = $_POST['fromdaytype'];
			$arr[15] = $_POST['todaytype'];
			$arr[16] = $_POST['timeoffrom'];
			$arr[17] = $_POST['timeofto'];
			$arr[18] = $_POST['leavebreakdown'];
			$dept = $this->loadModel('Employeeleave');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	 /**
     * Functions for perfom operation on leavetype table
     * delete function from leavetype list
	 * @returning json array of data as result
     */
	 
	 function updatedeemployeeleave()
	{
		$editper = $this->CheckPermission(18, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid']; 
			$arr[3] = $_POST['leavefrom'];
			$arr[4] = $_POST['leaveto'];
			$arr[5] = $_POST['leavereason'];
			$arr[6] = $_POST['leavetypeid']; 
			$arr[7] = $_POST['resumptiondate'];
			$arr[8] = $_POST['leaveid']; 
			$arr[9] = $_POST['applydate']; 
			$arr[10] = $_POST['leavestatus'];
			$arr[11] = $_POST['approvedby']; 
			$arr[12] = $_POST['approvercomment']; 
			$arr[13] = $_POST['contactdetail'];	
			$arr[14] = $_POST['dayseligible'];
			$arr[15] = $_POST['fromdaytype'];
			$arr[16] = $_POST['todaytype'];
			$arr[17] = $_POST['timeoffrom'];
			$arr[18] = $_POST['timeofto'];
			$arr[19] = $_POST['leavebreakdown'];
			$dept = $this->loadModel('Employeeleave');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteemployeeleave($did)
	{
		$deleteper = $this->CheckPermission(18, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Employeeleave');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getemployeeleaveData()
	{        	
		$editper = $this->CheckPermission(18, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(18, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$employeeleave = $this->loadModel('Employeeleave');
		$employeeleavearray = $employeeleave->getDataTable($editper, $deleteper);
		echo json_encode($employeeleavearray);
         }catch(Exception $e) {                              
				$errorMsg = 'Message: ' .$e->getMessage();
			}            		
		
	}
	
	function getLeaveDashboard($val,$type="")
	{   
		$arr = array();
		$arr[0] = $_SESSION['ubihrm_user_id'];
		$arr[1] = $_SESSION['ubihrm_org_id'];
		$arr[2] = $type;
		$arr[3] = $_POST['fiscalid'];
		$employeeleave = $this->loadModel('Dashboard');
		if($val==1){
			$employeeleavearray = $employeeleave->getLeaveDashboard1($arr);
		}else{
			$employeeleavearray = $employeeleave->getLeaveReportingDashboard($arr);
		}
		
		echo json_encode($employeeleavearray);
                     		
		
	}
	
	function filteremployeeleave()
	{
			$arr = array();
			
			$arr[0] = $_POST['department'];
			$arr[1] = $_POST['designation'];
			$arr[2] = $_POST['division'];
			$dept = $this->loadModel('Employeeleave');
			$deptarray = $dept->getFilterTable($arr);
			echo json_encode($deptarray);	

		
	}
	
	///////////////////////////////leave Elegibility controller/////////////////
	
	function leave_eligibility()
    {
       
	   $viewper = $this->CheckPermission(18, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(18, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('leave/leaveeligibility/index');
		}else{
			header('location: ' . URL . 'leave/index');
		}
    }
	

	function addleave_eligibility()
    {
		
		$addper = $this->CheckPermission(18, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->leaveeligibilityid =0;
			$this->view->render('leave/leaveeligibility/addeditleaveeligibility');
		}else{
			header('location: ' . URL . 'leave/leave_eligibility');
		}
    }
	
	function editleave_eligibility($id)
    {		
		$editper = $this->CheckPermission(18, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->leaveeligibilityid = $id; //$dept->getDetail($id);
			$this->view->render('leave/leaveeligibility/addeditleaveeligibility');
		}else{
			header('location: ' . URL . 'leave/leave_eligibility');
		}
    }
	
	function getallleave_eligibility()
	{		
		$viewper = $this->CheckPermission(18, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$leave_eligibility = $this->loadModel('Leaveeligibility');
			$leave_eligibilityarray = $leave_eligibility->getAll($arr);
			echo json_encode($leave_eligibilityarray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getaleave_eligibility()
	{
		

		$viewper = $this->CheckPermission(18, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['leaveeligibilityid'];
			$leave_eligibility = $this->loadModel('Leaveeligibility');
			$leave_eligibilityarray = $leave_eligibility->getDetail($gid);
			echo json_encode($leave_eligibilityarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}

     
	
	/** 
     * Functions for perfom operation on leavetype table
     * getall function fetching leavetype list
	 * @returning json array of data as result
     */ 

	function createleave_eligibility()
	{
		
	
	$addper = $this->CheckPermission(18, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['divisionid'];
			$arr[3] = $_POST['departmentid'];
			$arr[4] = $_POST['designationid'];
			$arr[5] = $_POST['gradeid']; 
			$arr[6] = $_POST['desc'];
			$arr[7] = $_POST['leavedays'];
			$arr[8] = $_POST['workdays'];
			
			$dept = $this->loadModel('Leaveeligibility');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	 /**
     * Functions for perfom operation on leavetype table
     * delete function from leavetype list
	 * @returning json array of data as result
     */
	 
	 function updatedeleave_eligibility()
	{
		$editper = $this->CheckPermission(18, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['divisionid'];
			$arr[3] = $_POST['departmentid'];
			$arr[4] = $_POST['designationid'];
			$arr[5] = $_POST['gradeid']; 
			$arr[6] = $_POST['desc'];
			$arr[7] = $_POST['leavedays'];
			$arr[8] = $_POST['leaveeligibilityid']; 
			$arr[9] = $_POST['workdays'];
			
			$dept = $this->loadModel('Leaveeligibility');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteleave_eligibility($did)
	{
		$deleteper = $this->CheckPermission(18, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Leaveeligibility');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getleave_eligibilityData()
	{        	
		$editper = $this->CheckPermission(18, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(18, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$leave_eligibility = $this->loadModel('Leaveeligibility');
		$leave_eligibilityarray = $leave_eligibility->getDataTable($editper, $deleteper);
		echo json_encode($leave_eligibilityarray);
                     		
		
	}

    /////////////////////leave approval controller///////////////////////
	function leave_approval()
    {
        $viewper = $this->CheckPermission(124, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(124, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('leave/leaveapproval/index');
		}else{
			header('location: ' . URL . 'leave/index');
		}
    }
	function timeoff_approval()
    {
        $viewper = $this->CheckPermission(180, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(180, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('leave/timeoffapproval/index');
		}else{
			header('location: ' . URL . 'leave/index');
		}
    }
	function addleaveapproval()
    {
		
		$addper = $this->CheckPermission(124, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->leaveapprovalid =0;
			$this->view->render('leave/leaveapproval/addeditleaveapproval');
		}else{
			header('location: ' . URL . 'leave/leave_approval');
		}
    }
	
	function editleaveapproval($id)
    {
		$editper = $this->CheckPermission(124, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->val = 0;
			$this->view->employeeleaveid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('leave/leaveapproval/addeditleaveapproval');
		}else{
			header('location: ' . URL . 'leave/leave_approval');
		}
    }
	function edittimeoffapproval($id)
    {
		$editper = $this->CheckPermission(180, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->val = 0;
			$this->view->employeetimeoffid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('leave/timeoffapproval/addedittimeoffapproval');
		}else{
			header('location: ' . URL . 'leave/leave_approval');
		}
    }
	function viewemployeeleaveapproval($id,$val)
    {
		$viewper = $this->CheckPermission(124, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		$hrsts = $_SESSION['ubihrm_hr_sts'];
		if(isset($id) && ($viewper)  && isset($val))
		{
			if($val==1 ){
				$this->view->val = $val; 
				$this->view->employeeleaveid = Utils::decode5t($id); //$dept->getDetail($id);
				$this->view->render('leave/leaveapproval/addeditleaveapproval');
			}	
			elseif($val==2 && $hrsts){
				$this->view->val = $val; 
				$this->view->employeeleaveid = Utils::decode5t($id); //$dept->getDetail($id);
				$this->view->render('leave/leaveapproval/addeditleaveapproval');
				
			}else{
				header('location: ' . URL . 'leave/leave_approval');
			}
		}else{
			header('location: ' . URL . 'leave/leave_approval');
		}
    }
	
	function getallleaveapproval()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$leaveapproval = $this->loadModel('Leaveapproval');
			$leaveapprovalarray = $leaveapproval->getAll($arr);
			echo json_encode($leaveapprovalarray);	
			
		
	}
	
	function getemployeeleaveapp()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$leaveapproval = $this->loadModel('Leaveapproval');
			$leaveapprovalarray = $leaveapproval->getEmployeeAllLeaveType($arr);
			echo json_encode($leaveapprovalarray);	
			
		
	}
	
	function getallleaveapprovalemp()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$leaveapproval = $this->loadModel('Employee');
			$leaveapprovalarray = $leaveapproval->getAllLeaveEmployee($arr);
			echo json_encode($leaveapprovalarray);	
			
		
	}
	
	function getaleaveapproval()
	{
		$viewper = $this->CheckPermission(124, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['leaveapprovalid'];
			$leaveapproval = $this->loadModel('Leaveapproval');
			$leaveapprovalarray = $leaveapproval->getDetail($gid);
			echo json_encode($leaveapprovalarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
function getatimeoffapproval()
	{
		$viewper = $this->CheckPermission(180, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['timeoffapprovalid'];
			$leaveapproval = $this->loadModel('Leaveapproval');
			$leaveapprovalarray = $leaveapproval->getTimeoffDetail($gid);
			echo json_encode($leaveapprovalarray);			
	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}	
	
	/** 
     * Functions for perfom operation on leaveapproval table
     * getall function fetching leaveapproval list
	 * @returning json array of data as result
     */ 

	function approveleaveapproval()
	{
		$addper = $this->CheckPermission(124, 2);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeleaveid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['comment'];
			$arr[5] = $_POST['leavebreakdown'];
			
			$dept = $this->loadModel('Leaveapproval');
			$deptarray = $dept->Approve($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	function approvetimeoffapproval()
	{
		$addper = $this->CheckPermission(180, 2);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeetimeoffid'];
			$arr[3] = $_POST['approverresult'];
			$arr[4] = $_POST['comment'];
		
			
			$dept = $this->loadModel('Leaveapproval');
			$deptarray = $dept->ApproveTimeoff($arr);
			echo json_encode($deptarray);	
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on leaveapproval table
     * delete function from leaveapproval list
	 * @returning json array of data as result
     */
	 
	 function forwardleaveapproval()
	{
		$editper = $this->CheckPermission(124, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeleaveid'];
			$arr[3] = $_POST['approverid'];
			
			$dept = $this->loadModel('Leaveapproval');
			$deptarray = $dept->Forward($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	function rejectleaveapproval()
	{
				
		
		$editper = $this->CheckPermission(124, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeleaveid'];
			
			
			
			$dept = $this->loadModel('Leaveapproval');
			$deptarray = $dept->Reject($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deleteleaveapproval($did)
	{
		$deleteper = $this->CheckPermission(124, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Leaveapproval');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getleaveapprovalData()
	{
		$editper = $this->CheckPermission(124, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(124, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$leaveapproval = $this->loadModel('Leaveapproval');
		$leaveapprovalarray = $leaveapproval->getDataTable($editper, $deleteper);
		echo json_encode($leaveapprovalarray);
	}

function gettimeoffapprovalData()
	{
		$editper = $this->CheckPermission(180, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(180, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		
		$leaveapproval = $this->loadModel('Timeoff');
		$leaveapprovalarray = $leaveapproval->getTimeoffDataTable($editper, $deleteper);
		echo json_encode($leaveapprovalarray);
	}
     ////////////////////////////  REPORT CONTROLLER FUNCTION STARTS HERE  ////////////////////////////
	
     /* Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	
	function report()
    {
		$viewper = $this->CheckPermission(60, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(60, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('leave/reports/index');
		}else{
			header('location: ' . URL . 'leave/index');
		}
    }
	function addreport()
    {
		$addper = $this->CheckPermission(60, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->reportid =0;
			$this->view->val = 0; 
			$this->view->render('leave/reports/addeditreport');
		}else{
			header('location: ' . URL . 'leave/report');
		}
    }
	
	function editreport($id)
    {
		$editper = $this->CheckPermission(60, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->reportid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('leave/reports/addeditreport');
		}else{
			header('location: ' . URL . 'leave/report');
		}
		
    }
	
	function viewreport1($id,$val)
    {
		
		if(isset($id)  && isset($val))
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->val = $val; 
			$this->view->render('leave/reports/addeditreport');
		}else{
			header('location: ' . URL . 'leave/report');
		}
		
    }
	function viewreport($id)
    {
		
		if(isset($id) )
		{
			$this->view->reportid = Utils::decode5t($id);
			$this->view->render('leave/reports/viewreport');
		}else{
			header('location: ' . URL . 'leave/report');
		}
		
    }
	function viewcustomreport($id,$val)
    {
		if(isset($id) && isset($val))
		{
			$id=Utils::decode5t($id);
			//Utils::Trace("This is custom viewreport id ".$id);
			$this->view->reportid =$id ;
			if($val==3){
				$this->view->render('leave/reports/leave_month_wise');
			}
			elseif($val==2){
				$this->view->render('leave/reports/leaveutilizedreport');
			}elseif($val==4){
				$this->view->render('attendance/reports/viewreport1');
			}elseif($val==17){
				$this->view->render('attendance/reports/perhourattendacne');
			}elseif($val==9){
				try{
				$salary = $this->loadModel('Report');
				$salaryarray = $salary->getDetail($id);
				$this->view->salarydetails=$salaryarray;
				$arr=array();
				$arr[0] = $_SESSION['ubihrm_user_id'];
				$arr[1] = $_SESSION['ubihrm_org_id'];
				
				$salary = $this->loadModel('Division');
				$this->view->divisions=$salary->getAll($arr);
				$salary = $this->loadModel('Department');
				$this->view->department=$salary->getAll($arr);
				$salary = $this->loadModel('Channel');
				$this->view->costcentre=$salary->getAll($arr);
				$this->view->render('salary/reports/salarydistribution');
				}catch(Exception $e){
					echo $e->getMessage();
					//header('location: ' . URL . 'salary/pastsalary');
				}
			}
			elseif($val==10){
				$this->view->render('leave/reports/annualleaveutilization');
			}
			elseif($val==11){
				$this->view->val=$val;
				$this->view->render('leave/reports/calendardayemp');
			}
			elseif($val==12){
				$this->view->val=$val;
				$this->view->render('leave/reports/calendardayemp');
			}
			elseif($val==13){
				$this->view->val=$val;
				$this->view->render('performance/reports/employeeassessment');
			}
			elseif($val==14){
				$this->view->val=$val;
				$this->view->render('salary/reports/salaryadditiondeduction');
			}
			elseif($val==15){
				$this->view->val=$val;
				$this->view->render('performance/reports/employeeassessment');
			}
			elseif($val==16){
				$this->view->val=$val;
				$this->view->render('salary/reports/employeegratuity');
			}
			elseif($val==18){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/monthlydetailreport');
			}
			elseif($val==19){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/todaytask');
			}
			elseif($val==20){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/delaytask');
			}
			elseif($val==21){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/earlytask');
			}
			elseif($val==22){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/monthlyreport');
			}
			elseif($val==23){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/projectreport');
			}
			elseif($val==24){
				$this->view->val=$val;
				$this->view->render('attendance/reports/monthlysummary');
			}
			elseif($val==29){
				try{
					$salary = $this->loadModel('Report');
					$salaryarray = $salary->getDetail($id);
					$this->view->salarydetails=$salaryarray;
					$arr=array();
					$arr[0] = $_SESSION['ubihrm_user_id'];
					$arr[1] = $_SESSION['ubihrm_org_id'];
					
					$salary = $this->loadModel('Division');
					$this->view->divisions=$salary->getAll($arr);
					$salary = $this->loadModel('Department');
					$this->view->department=$salary->getAll($arr);
					$salary = $this->loadModel('Channel');
					$this->view->costcentre=$salary->getAll($arr);
					$this->view->val=$val;
					$this->view->render('salary/reports/grandtotal');
				}catch(Exception $e){
					echo $e->getMessage();
					//header('location: ' . URL . 'salary/pastsalary');
				}	
			}
			elseif($val==32){
				$this->view->val=$val;
				$this->view->render('attendance/reports/latehrs');
			}
			elseif($val==30){
				$this->view->val=$val;
				$this->view->render('salary/reports/wpsreport');
			}
			elseif($val==31 || $val==37){
				$this->view->val=$val;
				$this->view->render('salary/reports/lbtreport');
			}
			elseif($val==40){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/Clientwiseproject');
			}elseif($val==42){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/ClientSummary');
			}
			elseif($val==43){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/ClientApplication');
			}elseif($val==45){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/ClientWiseProjectManagers');
			}elseif($val==46){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/gettimesheetbyproject');
			}elseif($val==47){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/getprojectwisetask');
			}elseif($val==48){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/TimesheetByEmployee');
			}elseif($val==49){
				$this->view->val=$val;
				$this->view->render('timesheet/reports/projectwisestatus');
			}			
		
			elseif($val==33){
				$this->view->val=$val;
				$this->view->render('salary/reports/btreport');
			}elseif($val==34){
				$this->view->val=$val;
				$this->view->render('salary/reports/esireport');
			}elseif($val==35){
				$this->view->val=$val;
				$this->view->render('salary/reports/pfreport');
			}elseif($val==36){
				$this->view->val=$val;
				$this->view->render('salary/reports/tdsreport');
			}
			elseif($val==38 || $val==39){
				try{
					$salary = $this->loadModel('Report');
					$salaryarray = $salary->getDetail($id);
					$this->view->salarydetails=$salaryarray;
					$arr=array();
					$arr[0] = $_SESSION['ubihrm_user_id'];
					$arr[1] = $_SESSION['ubihrm_org_id'];
					
					$salary = $this->loadModel('Division');
					$this->view->divisions=$salary->getAll($arr);
					$salary = $this->loadModel('Department');
					$this->view->department=$salary->getAll($arr);
					$salary = $this->loadModel('Channel');
					$this->view->costcentre=$salary->getAll($arr);
					$this->view->val=$val;
					
					if($val==39)
						$this->view->render('salary/reports/njvreport2');
					else
						$this->view->render('salary/reports/njvreport');
				}
				catch(Exception $e){
					echo $e->getMessage();
					//header('location: ' . URL . 'salary/pastsalary');
				}	
				
			}elseif($val==41){
				$this->view->val=$val;
				$this->view->render('salary/reports/gratuityjv');
			}
			elseif($val==44){
				$this->view->val=$val;
				$this->view->render('performance/reports/empskillgaps');
			}
		}else{
			header('location: ' . URL . 'leave/report');
		}
		
    }
	
	
	function getallreport()
	{
		$viewper = $this->CheckPermission(60, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$report = $this->loadModel('Report');
			$reportarray = $report->getAll($arr);
			echo json_encode($reportarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getclientwisetreport(){
		$viewper = $this->CheckPermission(60, 1);
		
		if($viewper){
			$gid = $_POST['reportid'];
			$report = $this->loadModel('Report');
			$reportarray = $report->getDetail($gid);
			echo json_encode($reportarray);
			}else{
				$result = array();
				$result['status'] = false;
				$result['errorMsg'] = "You don't have data view permission";
				echo json_encode($result);
			}
	}
	
	function getareport()
	{
		$viewper = $this->CheckPermission(60, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['reportid'];
			$report = $this->loadModel('Report');
			$reportarray = $report->getDetail($gid);
			echo json_encode($reportarray);
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	function daterangereport($val)
	{
		try{
			$deptarray=array();
			$dept = $this->loadModel('Report');
			if($val==1){
				$deptarray = $dept->createLeaveReport();
			}
			elseif($val==2){
				$deptarray = $dept->createLeaveUtilizedTable();
			}
			elseif($val==3){
				$deptarray = $dept->AttendanceSummaryReport();
			}
			elseif($val==4){
				$deptarray = $dept->EmployeeLeaveHistory();
			}
			elseif($val==17){
				$deptarray = $dept->AttendanceMonthlyReport();
			}
			
			elseif($val==11 || $val==12){
				$deptarray = $dept->CalenderDaysAnnaulLeaveEmp($val);
			}
			elseif($val==18){
				$deptarray = $dept->TimesheetMonthlyReport();
			}
			elseif($val==19){
				$deptarray = $dept->TimesheetDailyReport();
			}
			elseif($val==20){
				$deptarray = $dept->TimesheetDelayReport();
			}
			elseif($val==21){
				$deptarray = $dept->TimesheetEarlyReport();
			}
			elseif($val==22){
				$deptarray = $dept->MonthlyReport();
			}
			elseif($val==23){
				$deptarray = $dept->ProjectReport();
			}
			elseif($val==24){
				$deptarray = $dept->AttendanceMonthlysummary();
			}
			elseif($val==32){
				$deptarray = $dept->DateWiseLateHours();
			}
			elseif($val==40){
				$deptarray = $dept->getclientwiseReport();
			}elseif($val==42){
				$deptarray = $dept->getclientsummary();
			}elseif($val==43){
				$deptarray = $dept->getclientapplication();
			}elseif($val==45){
				$deptarray = $dept->getclientwiseprojectmanager();
			}elseif($val==46){
				$deptarray = $dept->gettimesheetbyproject();
			}elseif($val==47){
				$deptarray = $dept->getprojectwisetask();
			}elseif($val==48){
				$deptarray = $dept->getprojectwiseemployee();
			}elseif($val==49){
				$deptarray = $dept->getprojectwisestatus();
			}
			echo json_encode($deptarray);
		}catch(Exception $e) {
			echo $e->getMessage();
		}
	}
	/** 
     * Functions for perfom operation on report table
     * getall function fetching report list
	 * @returning json array of data as result
     */
	function createreport()
	{
		$addper = $this->CheckPermission(60, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			try{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['reportname'];
			$arr[3] = $_POST['modulename'];
			$arr[4] = $_POST['selectcol'];
			$arr[5] = $_POST['selectcrit'];
			$arr[6] = $_POST['groupby'];
			$arr[7] = $_POST['reportype'];
			$arr[8] = $_POST['totalcolumn'];
			$arr[9] = $_POST['tabid'];
			
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);
			}catch(Exception $e) {
			echo $e->getMessage();
		}
		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on report table
     * delete function from report list
	 * @returning json array of data as result
     */
	 
	 function updatedreport()
	{
		$editper = $this->CheckPermission(60, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['reportname'];
			$arr[3] = $_POST['modulename'];
			$arr[4] = $_POST['selectcol'];
			$arr[5] = $_POST['selectcrit'];
			$arr[6] = $_POST['groupby'];
			$arr[7] = $_POST['reportid'];
			$arr[8] = $_POST['reportype'];
			$arr[9] = $_POST['totalcolumn'];
			$arr[10] = $_POST['tabid'];
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
	}
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletereport($did)
	{
		$deleteper = $this->CheckPermission(60, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Report');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function getReportData()
	{
		$editper = $this->CheckPermission(60, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(60, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		$tabid=3;
		$report = $this->loadModel('Report');
		$reportarray = $report->getDataTable($editper, $deleteper,$tabid);
		echo json_encode($reportarray);
	}
	
	function getReportData1($id)
	{
		//echo $id;	
		$editper = $this->CheckPermission(60, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(60, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$report = $this->loadModel('Report');
		$reportarray = $report->createDataTable($id);
		echo json_encode($reportarray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	function getLeaveReportData()
	{
		$editper = $this->CheckPermission(60, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(60, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
			$report = $this->loadModel('Report');
			$reportarray = $report->createLeaveUtilizedTable();
			echo json_encode($reportarray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	function createReportDataTable()
	{
		$editper = $this->CheckPermission(60, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(60, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
			$report = $this->loadModel('Report');
			$reportarray = $report->createDataTable($editper, $deleteper);
			echo json_encode($reportarray);
		}catch(Exception $e){
			echo $e->getMessage();
		}
	}
	
	function getmodules()
	{
		$permission = $this->loadModel('Permission');
		$perarray = $permission->getModules();
		echo json_encode($perarray);	
	}
	
	function getcolumnvalues()
	{
		
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['tablename'];
			$arr[3] = $_POST['columnname'];
			$dept = $this->loadModel('Report');
			$deptarray = $dept->getAllColumnValue($arr);
			echo json_encode($deptarray);	
		
	}
	function getreportingmodule()
    {
		$tabid=$_POST['tabid'];
        $relation = $this->loadModel('Permission');
		$relationarr = $relation->getReportingModules($tabid);
		echo json_encode($relationarr);
    }
	
	//////////////time off controller starts from here/////////////
	function timeoff()
    {
       
	   $viewper = $this->CheckPermission(179, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper){
			$addper = $this->CheckPermission(179, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
			$this->view->addper =$addper;
			$this->view->render('leave/timeoff/index');
		}else{
			header('location: ' . URL . 'leave/index');
		}
    }
	
	function addtimeoff()
    {
		$addper = $this->CheckPermission(179, 4); ///////// CHECK FOR ADD EMPLOYEE PERMISSION  ////////////
		if($addper){
			$this->view->timeoffid =0;
			$this->view->val = 0;
			$this->view->render('leave/timeoff/addedittimeoffapplication');
		}else{
			header('location: ' . URL . 'leave/timeoff');
		}
    }
	
	function edittimeoff($id)
    {		
		$editper = $this->CheckPermission(179, 2); ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		if(isset($id) && ($editper))
		{
			$this->view->timeoffid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->val = 0; 
			$this->view->render('leave/timeoff/addedittimeoffapplication');
		}else{
			header('location: ' . URL . 'leave/timeoff');
		}
    }
	
	function viewtimeoff($id,$val)
    {
		$viewper = $this->CheckPermission(179, 1); ///////// CHECK FOR VIEW PERMISSION  ////////////
		
		if(isset($id) && ($viewper)  && isset($val))
		{
			
			$this->view->val = $val; 
			$this->view->timeoffid = Utils::decode5t($id); //$dept->getDetail($id);
			$this->view->render('leave/timeoff/addedittimeoffapplication');
		}else{
			header('location: ' . URL . 'leave/timeoff');
		}
		
    }
	
	function getemployeetimeoff()
	{
		$viewper = $this->CheckPermission(18, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['timeoffid'];
			$employeeleave = $this->loadModel('Employeeleave');
			$employeeleavearray = $employeeleave->getTimeOffDetail($gid);
			echo json_encode($employeeleavearray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}
	function getalltimeoff()
	{		
		$viewper = $this->CheckPermission(179, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			
			$timeoff = $this->loadModel('Timeoff');
			$timeoffarray = $timeoff->getAll($arr);
			echo json_encode($timeoffarray);		
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}
	}
	
	function getatimeoff()
	{
		

		$viewper = $this->CheckPermission(179, 1);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($viewper)
		{
			$gid = $_POST['timeoffid'];
			$timeoff = $this->loadModel('Timeoff');
			$timeoffarray = $timeoff->getDetail($gid);
			echo json_encode($timeoffarray);	
			
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data view permission";
			echo json_encode($result);		
		}		
	}

     
	
	/** 
     * Functions for perfom operation on leavetype table
     * getall function fetching leavetype list
	 * @returning json array of data as result
     */ 

	function createtimeoff()
	{
		
		$addper = $this->CheckPermission(179, 4);  ///////// CHECK FOR VIEW PERMISSION  ////////////
		if($addper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['timeoffdate'];
			$arr[4] = $_POST['fromtime'];
			$arr[5] = $_POST['totime'];
			$arr[6] = $_POST['timeoffreason'];
			
			$dept = $this->loadModel('Timeoff');
			$deptarray = $dept->Create($arr);
			echo json_encode($deptarray);	

		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data add permission";
			echo json_encode($result);		
		}
	}
	 /**
     * Functions for perfom operation on leavetype table
     * delete function from leavetype list
	 * @returning json array of data as result
     */
	 
	 function updatedtimeoff()
	{
		$editper = $this->CheckPermission(179, 2);   ///////// CHECK FOR EDIT  PERMISSION  ////////////
		try{
			if($editper)
		{
			$arr = array();
			$arr[0] = $_SESSION['ubihrm_user_id'];
			$arr[1] = $_SESSION['ubihrm_org_id'];
			$arr[2] = $_POST['employeeid'];
			$arr[3] = $_POST['timeoffdate'];
			$arr[4] = $_POST['fromtime'];
			$arr[5] = $_POST['totime'];
			$arr[6] = $_POST['timeoffreason'];
			$arr[7] = $_POST['timeoffid'];
			
			$dept = $this->loadModel('Timeoff');
			$deptarray = $dept->Update($arr);
			echo json_encode($deptarray);		
					
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data edit permission";
			echo json_encode($result);		
		}
			
		}catch(Exception $e){}
		
	}
	
	
	
	 /**
     * Functions for perfom operation on Department table
     * delete function from department list
	 * @returning json array of data as result
     */
	function deletetimeoff($did)
	{
		$deleteper = $this->CheckPermission(179, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		if(isset($did) && $deleteper )
		{
			$dept = $this->loadModel('Timeoff');
			$deptarray = $dept->Delete($did);
		echo json_encode($deptarray);	

		
		}else{
			$result = array();
			$result['status']=false;
			$result['errorMsg']="You don't have data delete permission";
			echo json_encode($result);		
		}
	}
	
	/**
     * Functions specific for datatable jquery
     * @returning json array of data as result
     */
	function gettimeoffData()
	{        	
		$editper = $this->CheckPermission(179, 2);   ///////// CHECK FOR EDIT EMPLOYEE PERMISSION  ////////////
		$deleteper = $this->CheckPermission(179, 3); ///////// CHECK FOR DELETE EMPLOYEE PERMISSION  ////////////
		try{
		$timeoff = $this->loadModel('Timeoff');
		$timeoffarray = $timeoff->getDataTable($editper, $deleteper);
		echo json_encode($timeoffarray);
         }catch(Exception $e) {                              
				$errorMsg = 'Message: ' .$e->getMessage();
			}            		
		
	}
	function getempteam($id)
	{
		try{
		$data = $this->loadModel('Report');
		$data1 = $data->getempteam($id);
		echo json_encode($data1);
         }catch(Exception $e) {                              
				$errorMsg = 'Message: ' .$e->getMessage();
			}   
	}
	
}
